
*****************************************************
*           REGRESSIONSANALYSE                      *
*              Josef Brüderl                        *
*              Oktober 2018                         *
*****************************************************

*****************************************************
* Das multiple Regressionsmodell
*****************************************************

clear 
set more off
version 15

* Daten: ALLBUS 2002
cd   "C:\Users\Brüderl\LRZ Sync+Share\Vorlesung Querschnittsdatenanalyse\Do Files"        //Arbeitsverzeichnis
use  AllbReg, clear


*****************************************************
* Datenaufbereitung
*****************************************************
* Nur Westdeutschland, hauptberuflich ganztags, bis Alter 65
keep if  ost  == 0
keep if  hauptber == 1
keep if  alter <  66

misstable summarize eink prestv bild   // summary of missing values
gen sample = ~ missing(eink,bild,prestv)
keep if sample==1


****************************************************
* Bsp.: Das Statuszuweisungsmodell 
****************************************************

* Konfundierung
regress    eink bild            // Bivariate Regression
est store  m1

regress    eink bild prestv     // Multiple Regression
est store  m2

regress eink prestv             // Residuum eink
predict eink_res, resid

regress bild prestv             // Residuum bild
predict bild_res, resid

corr eink_res bild_res prestv   // Korrelation der Residuen/Confounder

regress    eink_res bild_res    // Residuen Regression
est store  m3

esttab m1 m2 m3, b(%6.2f) star se r2


* Mediation
regress    eink prestv
est store  m4

esttab m4 m2, b(%6.2f) star se r2

* Sobel-Test
* net install sgmediation.pkg

sgmediation eink, mv(bild) iv(prestv)


* Das Statuszuweisungsmodell komplett
regress  eink bild prestv, beta   //standard. Regressionskoeffizienten
regress       bild prestv, beta


